DROP PACKAGE SDSADM.SDS_UTIL;

CREATE OR REPLACE PACKAGE SDSADM.sds_util AUTHID CURRENT_USER
AS
-- Declare externally callable procedures
  PROCEDURE disable_constraints;
  PROCEDURE disable_fkeys;
  PROCEDURE disable_fkeys(schema_name IN VARCHAR2);
  PROCEDURE disable_triggers;
  PROCEDURE drop_fkeys;
  PROCEDURE drop_mviews;
  PROCEDURE drop_mvlogs;
  PROCEDURE drop_fkeys(schema_name IN VARCHAR2);
  PROCEDURE enable_constraints;
  PROCEDURE enable_fkeys;
  PROCEDURE enable_fkeys(schema_name IN VARCHAR2);
  PROCEDURE enable_triggers;
  PROCEDURE refresh_mviews(doCompleteRefresh BOOLEAN DEFAULT FALSE);
  PROCEDURE test_mviews(doRefresh BOOLEAN DEFAULT FALSE,
                        doCompleteRefresh BOOLEAN DEFAULT FALSE);
  PROCEDURE truncate_tables;
END sds_util;
 
/


CREATE OR REPLACE PUBLIC SYNONYM SDS_UTIL FOR SDSADM.SDS_UTIL;


GRANT EXECUTE ON SDSADM.SDS_UTIL TO PUBLIC;
